/*
  errors and its handling
  written by alexander yaworsky
  '99
*/

#include <windows.h>

#include "stdlib.h"
#include "stringlist.h"
#include "errors.h"
#include "switches.h"


static char* ErrTable[] = {
    "function code is required",
    "invalid password",
    "invalid number of parameters",
    "Win32 API error",
    "not supported in this version",
    "invalid function code",
    "password length must be exactly 32 bytes",
    "out of memory",
    "invalid root key",
    "process not found",
    "exception occured",
    "cannot register server on this workstation",
    "function is not supported on this platform",
    "bad registration data",
    "bad CRC of request",
    "request reception error",
    "screen/winshot error",
    "invalid protocol name",
    "chat initialization failed",
    "invalid chat size (1..64K allowed)",
    "cannot write parameter to registry",
    "cannot read parameter from registry",
    "parameter too long"
  };

#define ErrTableSz (sizeof(ErrTable)/sizeof(ErrTable[0]))


void SetReply( STRINGLIST* Result, int ErrorCode, char* ErrorDesc )
  {
    char  Buf[ 1024 ];
    char  *ErrStr;

    if( ErrorCode == ERR_NO_ERROR )
      lstrcpy( Buf, "OK" );
    else {
      if( ErrorCode < 1 || ErrorCode > ErrTableSz )
        ErrStr = "unknown error";
      else
        ErrStr = ErrTable[ ErrorCode - 1 ];
      wsprintf( Buf, "ERROR %11d %11d %s %s", ErrorCode, GetLastError(),
                ErrStr, ErrorDesc );
    }
    AddToStringList( Result, Buf );
  }
